<?php
	require_once('Test/yconfiguration.php');
	require_once('lib/nusoap.php');
	require_once('Test/ylib.php');

	$ns=$path_html;
	
	$server = new soap_server();
	$server->configureWSDL('Pedidos',$ns);
	$server->wsdl->schemaTargetNamespace=$ns;
	
	$server->register('wsValidaUsuario',array('Usuario' => 'xsd:string','Clave' => 'xsd:string'),array('return' => 'xsd:string'),$ns);	
	$server->register('wsInsertaPedido',array('DatosPedido' => 'xsd:string'),array('return' => 'xsd:string'),$ns);
	$server->register('wsInsertaDetallePedido',array('DatosDetallePedido' => 'xsd:string'),array('return' => 'xsd:string'),$ns);
	$server->register('wsInsertaDocumentoPedido',array('DatosDocumento' => 'xsd:string'),array('return' => 'xsd:string'),$ns);
	$server->register('wsInsertaDevoluciones', array('DatosDevolucion' => 'xsd:string'),array('return' => 'xsd:string'),$ns);
	$server->register('wsInsertaDevolucionesDetalle', array('DatosDevolucion' => 'xsd:string'),array('return' => 'xsd:string'),$ns);
	$server->register('wsGetRutaClientes',array('P_fk_Vendedor' => 'xsd:string','P_Dia_Inicio' => 'xsd:string','P_Dia_Final' => 'xsd:string'),array('return' => 'xsd:xml'),$ns);
	$server->register('wsGetGrupos',array('p_codigo' => 'xsd:string','p_sort'  => 'xsd:string'),array('return' => 'xsd:xml'),$ns);
	$server->register('wsGetNivelesPrecio',array('p_codigo' => 'xsd:string','p_sort'  => 'xsd:string'),array('return' => 'xsd:xml'),$ns);
	$server->register('wsGetTiposDocumentos',array('p_codigo' => 'xsd:string','p_sort'  => 'xsd:string'),array('return' => 'xsd:xml'),$ns);
	$server->register('wsGetProductos',array('p_grupo' => 'xsd:string','p_codigo' => 'xsd:string','p_sort' => 'xsd:string'),array('return' => 'xsd:xml'),$ns);

	
	function wsValidaUsuario($Usuario,$Clave )
	{
		$Datos=VerificaUsuario($Usuario,$Clave);
		if($Datos->EOF)
		{
			$Valor="0";//usuario invalido
		}
		else
		{
			$Valor="1";//usuario valido
		}		
		return $Valor;
	}//fin
	
	function wsInsertaPedido($DatosPedido)
	{
		$ArrayPedido=explode(',',$DatosPedido);
		$Datos=InsertaPedido($ArrayPedido[0],$ArrayPedido[1],$ArrayPedido[2],$ArrayPedido[3],$ArrayPedido[4],$ArrayPedido[5],$ArrayPedido[6],$ArrayPedido[7],$ArrayPedido[8],$ArrayPedido[9],$ArrayPedido[10],$ArrayPedido[11],$ArrayPedido[12],$ArrayPedido[13]);

		$Valor=$Datos[0]['New_Id'];
		return $Valor;
		
	}//fin
	
	function wsInsertaDetallePedido($DatosDetallePedido)
	{
		$ArrayPedido=explode(',',$DatosDetallePedido);
		$Datos=InsertaDetallePedido($ArrayPedido[0],$ArrayPedido[1],$ArrayPedido[2],$ArrayPedido[3],$ArrayPedido[4],$ArrayPedido[5]);

		$Valor=$Datos[0]['New_Id'];
		return $Valor;
		
	}//fin
	
	function wsInsertaDocumentoPedido($DatosDocumento)
	{
		$ArrayPedido=explode(',',$DatosDocumento);
		$Datos=InsertaDocumentoPedido($ArrayPedido[0],$ArrayPedido[1],$ArrayPedido[2]);

		$Valor=$Datos[0]['New_Id'];
		return $Valor;
		
	}//fin
	
	function wsInsertaDevoluciones($DatosDevolucion)
	{
		$ArrayDevolucion=explode(',',$DatosDevolucion);
				$Datos=InsertaDevoluciones($ArrayDevolucion[0],$ArrayDevolucion[1],$ArrayDevolucion[2],$ArrayDevolucion[3],$ArrayDevolucion[4],$ArrayDevolucion[5]);

		$Valor=$Datos[0]['New_Id'];
		return $Valor;
		
	}//fin

	function wsInsertaDevolucionesDetalle($DatosDetalleDevolucion)
	{
		$ArrayDevolucion=explode(',',$DatosDetalleDevolucion);
				$Datos=InsertaDevolucionesDetalle($ArrayDevolucion[0],$ArrayDevolucion[1],$ArrayDevolucion[2],$ArrayDevolucion[3],$ArrayDevolucion[4],$ArrayDevolucion[5],$ArrayDevolucion[6],$ArrayDevolucion[7],$ArrayDevolucion[8],$ArrayDevolucion[9],$ArrayDevolucion[10],$ArrayDevolucion[11],$ArrayDevolucion[12]);

		$Valor=$Datos[0]['New_Id'];
		return $Valor;
		
	}//fin

	function wsGetRutaClientes($P_fk_Vendedor,$P_Dia_Inicio,$P_Dia_Final)
	{
		$rsArray=GetRutaClientes($P_fk_Vendedor,$P_Dia_Inicio,$P_Dia_Final);

		//crear el xml para enviar de regreso
		
		$Xml='<?xml version="1.0" encoding="UTF-8" ?>';
		$Xml .= '<Clientes>';
		for($i=0;$i<count($rsArray);$i++)
		{		
			$Xml .='<rec_data>'.$rsArray[$i]['rec_data'].'</rec_data>';
		
		}//fin for
		$Xml .= '</Clientes>';
		
		return ($Xml);
	}//fin funcion
	
	
	function wsGetGrupos($p_codigo,$p_sort)
	{
		$rsArray=GetGrupos($p_codigo,$p_sort);
		
		$Xml='<?xml version="1.0" encoding="UTF-8" ?>';
		$Xml .= '<Grupos>';
		for($i=0;$i<count($rsArray);$i++)
		{		
			$Xml .='<rec_data>'.$rsArray[$i]['rec_data'].'</rec_data>';
		
		}//fin for
		$Xml .= '</Grupos>';
		
		return ($Xml);
		
	}//fin
	
	function wsGetNivelesPrecio($p_codigo,$p_sort)
	{
		$rsArray=GetNivelesPrecio($p_codigo,$p_sort);
		
		$Xml='<?xml version="1.0" encoding="UTF-8" ?>';
		$Xml .= '<NivelesPrecio>';
		
		for($i=0;$i<count($rsArray);$i++)
		{		
			$Xml .='<rec_data>'.$rsArray[$i]['rec_data'].'</rec_data>';
						
		}//fin for
		
		$Xml .= '</NivelesPrecio>';
		
		return ($Xml);
		
	}//fin
	
	
	function wsGetTiposDocumentos($p_codigo,$p_sort)
	{
		$rsArray=GetTiposDocumentos($p_codigo,$p_sort);
		
		$Xml='<?xml version="1.0" encoding="UTF-8" ?>';
		$Xml .= '<Documentos>';
		for($i=0;$i<count($rsArray);$i++)
		{		
			$Xml .='<rec_data>'.$rsArray[$i]['rec_data'].'</rec_data>';			
		}//fin for
		$Xml .= '</Documentos>';
		
		return ($Xml);
		
	}//fin
	
	function wsGetProductos($p_grupo,$p_codigo,$p_sort)
	{
		$rsArray=GetProductos($p_grupo,$p_codigo,$p_sort);
		
		$Xml='<?xml version="1.0" encoding="UTF-8" ?>';
		$Xml .= '<Productos>';
		for($i=0;$i<count($rsArray);$i++)
		{		
			$Xml .='<data>'.$rsArray[$i]['data'].'</data>';			
		}//fin for
		$Xml .= '</Productos>';
		
		return ($Xml);
		
	}//fin

	if ( !isset( $HTTP_RAW_POST_DATA ) ) $HTTP_RAW_POST_DATA =file_get_contents( 'php://input' );
	
	$server->service($HTTP_RAW_POST_DATA);
?>