<?php
	
	error_reporting(0);
	//Establecemos los datos para la conexion a la base
	$servidor = 'localhost';
	//$usuario = 'dcasave2_phpuser';
	$usuario = 'dcasave2_phpuser';
	//$password = 'passweb';
	$password = 'norvasc2015';
	//$BaseDatos = 'dcasave2_pedidos';
	$BaseDatos = 'dcasave2_pedidos';
	
	// set default timezone
	date_default_timezone_set('America/Guatemala'); // CDT

	//Consumimos el Json recibido
	$data = file_get_contents('php://input');
	$json = json_decode($data);
	$data = $json->{'data'};
	$serie_recibo = $data->{'serie_recibo'};
	$cod_cobrador = $data->{'cod_cobrador'};
	$liquidacion = $data->{'liquidacion'};	
	$recibos = $data->{'recibos'};	//Recibos	
	$depositos = $data->{'depositos'}; //Depositos
    $liquidacion_pk=-1;
    $recibo_pk=-1;
    $deposito_pk=-1;
    $cheque_pre_pk=-1;
    $tipo_forma_pago_pk=-1;
    $ack=false;
    $msg="";
    $CantDocsLiq=0;//Indica la cantidad de documentos enlazados a la liquidacion
    $existe_liq=false;
	try {
		//Nos conectamos a la base
		$conexion = new mysqli($servidor, $usuario, $password, $BaseDatos);

		/* comprobar la conexión */
		if ($mysqli->connect_errno) {
			throw new Exception('No se pudo establecer una conexión a la base de datos. ');
		}
		
		//Deshabilitamos el autocommit para llevar a cabo la transacción
		//con varias sentencias
		$conexion->autocommit(false);


		//INSERTAR LIQUIDACION
		$Numero_Tel 			= ($cod_cobrador * 100000) + $liquidacion->{'no'};
		$Fk_Cobrador 			= $cod_cobrador;
		$Fecha 					= $liquidacion->{'fecha'};
		$Recibos_de_Caja 		= $liquidacion->{'r_caja'};
		$Recibos_Prov 			= $liquidacion->{'r_prov'};
		$Total_Recibos 			= $liquidacion->{'r_total'};
        $Depositos 				= $liquidacion->{'depositos'};
        $Boletas 				= $liquidacion->{'boletas'};
        $Tarjetas 				= $liquidacion->{'tarjetas'};
        $Cheques_Prefechados 	= $liquidacion->{'cheque_pre'};
        $Estado 				= 'E'; 
        $Numero_Documentos      = 0; //Se actualiza hasta el final

        //Verificar si la liquidacion ya fue ingresada
		$InstruccionBD = $conexion->prepare("select pk from co_t_liquidaciones where numero_tel = ? and fk_cobrador = ? limit 1");		 
		$InstruccionBD->bind_param('ii', $Numero_Tel, $Fk_Cobrador);				
		$InstruccionBD->execute();
		if ($InstruccionBD->errno) {
		  throw new Exception( "Ocurrio un error al intentar obtener la llave primaria de la liquidacion. " . $InstruccionBD->error);
		}
		$InstruccionBD->store_result();			
		$NumeroRegistros = $InstruccionBD->num_rows;
		if ( $NumeroRegistros > 0 ) {	
			$InstruccionBD->data_seek(0);
			$InstruccionBD->bind_result($liquidacion_pk);
			$InstruccionBD->fetch();
			$existe_liq=true;							
		}
		$InstruccionBD ->close();
		//FIN VERIFICAR LIQUIDACION INGRESADA 

		if(!$existe_liq)
		{
			$InstruccionBD = $conexion->prepare("insert into co_t_liquidaciones (Numero_Tel, Fk_Cobrador, Fecha, Recibos_de_Caja, Recibos_Prov, Total_Recibos, Depositos, Boletas, Tarjetas, Cheques_Prefechados, Estado, Numero_Documentos, Fecha_Envio) values (?,?,?,?,?,?,?,?,?,?,?,?,NOW());");		 
			$InstruccionBD->bind_param('iisdddddddsi', $Numero_Tel, $Fk_Cobrador, $Fecha, $Recibos_de_Caja, $Recibos_Prov, $Total_Recibos, $Depositos, $Boletas, $Tarjetas, $Cheques_Prefechados, $Estado, $Numero_Documentos);				
			$InstruccionBD->execute();	
			if ($InstruccionBD->errno) {
			  throw new Exception( "Ocurrio un error al intentar insertar la liquidacion. " . $InstruccionBD->error);
			}
			$InstruccionBD ->close();

			//****RECUPERAR EL PK DE LA LIQUIDACION GENERADA****
			$InstruccionBD = $conexion->prepare("select pk from co_t_liquidaciones where numero_tel = ? and fk_cobrador = ? limit 1");		 
			$InstruccionBD->bind_param('ii', $Numero_Tel, $Fk_Cobrador);				
			$InstruccionBD->execute();
			if ($InstruccionBD->errno) {
			  throw new Exception( "Ocurrio un error al intentar obtener la llave primaria de la liquidacion. " . $InstruccionBD->error);
			}
			$InstruccionBD->store_result();			
			$NumeroRegistros = $InstruccionBD->num_rows;
			if ( $NumeroRegistros > 0 ) {	
				$InstruccionBD->data_seek(0);
				$InstruccionBD->bind_result($liquidacion_pk);
				$InstruccionBD->fetch();							
			}
			else
			{
				throw new Exception( "Ocurrio un error al intentar recuperar la llave primaria de la liquidacion No. " . $liquidacion->{'no'}) ;
			}
			$InstruccionBD ->close();
			//FIN INSERTAR LIQUIDACION

		   //****INSERTAR DEPOSITOS A LA DB*****	 
		   for ($i=0; $i<count($depositos); $i++){
				$fk_cobrador		= $cod_cobrador;
				$fk_banco			= $depositos[$i]->{'cod_banco'};		
				$cod_cuenta_bancaria= $depositos[$i]->{'cod_cuenta'};	
				$boleta_numero		= $depositos[$i]->{'no_boleta'};	
				$fecha				= $depositos[$i]->{'fecha'};	               
				$total				= $depositos[$i]->{'total'};	
				$efectivo			= $depositos[$i]->{'efectivo'};	
				$cheques			= $depositos[$i]->{'cheque'};	
				$cheques_ob			= $depositos[$i]->{'cheque_sob'};	
				
				
				//Obtener la llave primaria del banco a la que pertenece el codigo de cta
				$InstruccionBD = $conexion->prepare("select pk from co_t_bancos_cuentas where codigo = ? and fk_banco = ? limit 1");
				$InstruccionBD->bind_param('si', $cod_cuenta_bancaria, $fk_banco);
				$InstruccionBD->execute();
				if ($InstruccionBD->errno) {
				  throw new Exception( "Ocurrio un error al intentar obtener la llave primaria del banco al que pertenece el No. de Cta. -- " . $InstruccionBD->error);
				}
				$InstruccionBD->store_result();			
				$NumeroRegistros = $InstruccionBD->num_rows;
				
				
				if ( $NumeroRegistros > 0 ) {				
					$InstruccionBD->data_seek(0);
					$InstruccionBD->bind_result($fk_cuenta_bancaria);
					$InstruccionBD->fetch();	

					//Insertar a el deposito a la base de datos								
					$InstruccionBD = $conexion->prepare("insert into co_t_depositos (fk_cobrador, fk_banco, fk_cuenta_bancaria, boleta_numero, fecha, total, efectivo, cheques, cheques_ob, fecha_envio) values (?,?,?,?,?,?,?,?,?,NOW());");		 
					$InstruccionBD->bind_param('iiissdddd', $fk_cobrador, $fk_banco, $fk_cuenta_bancaria, $boleta_numero, $fecha, $total, $efectivo, $cheques, $cheques_ob);				
					$InstruccionBD->execute();					
				}
				else
				{				
					throw new Exception('El No. de cuenta: ' . $cod_cuenta_bancaria . ', asociado al depósito con boleta no.: ' . $boleta_numero . ' no existe. ');
				}
				$InstruccionBD ->close();


				//****RECUPERAR EL PK DEL DEPOSITO INSERTADO****
				$InstruccionBD = $conexion->prepare("select pk from co_t_depositos where fk_cobrador = ? and fk_banco = ? and boleta_numero = ? and total = ? limit 1");		 
				$InstruccionBD->bind_param('iisd', $fk_cobrador, $fk_banco, $boleta_numero, $total);				
				$InstruccionBD->execute();
				if ($InstruccionBD->errno) {
				  throw new Exception( "Ocurrio un error al intentar obtener la llave primaria del deposito. " . $InstruccionBD->error);
				}
				$InstruccionBD->store_result();			
				$NumeroRegistros = $InstruccionBD->num_rows;
				if ( $NumeroRegistros > 0 ) {	
					$InstruccionBD->data_seek(0);
					$InstruccionBD->bind_result($deposito_pk);
					$InstruccionBD->fetch();							
				}
				else
				{
					throw new Exception( "Ocurrio un error al intentar recuperar la llave primaria del deposito No. " . $boleta_numero) ;
				}
				$InstruccionBD ->close();

				//INSERTAR LIQUIDACION DEPOSITO
				$InstruccionBD = $conexion->prepare("insert into co_t_liquidaciones_depositos (fk_liquidacion, fk_deposito) values (?,?)");		 
				$InstruccionBD->bind_param('ii', $liquidacion_pk, $deposito_pk);				
				$InstruccionBD->execute();	
				if ($InstruccionBD->errno) {
				  throw new Exception( "Ocurrio un error al insertar el deposito en la liquidacion. " . $InstruccionBD->error);
				}
				$InstruccionBD ->close();

				
		   }
		   	$CantDocsLiq+=count($depositos);//Sumar los depositos insertados a los docs de la liquidacion
		   //FIN INSERTAR DEPOSITOS

		   //********INSERTAR RECIBOS A LA DB******
			for ($i=0; $i<count($recibos); $i++){
			
				$Tipo_Recibo 	= $recibos[$i]->{'tipo'};
				$Serie_Recibo 	= $serie_recibo;
				$Numero_Recibo 	= $recibos[$i]->{'no'};
				$Fk_Cobrador 	= $cod_cobrador;
				$Fk_Cliente 	= $recibos[$i]->{'cte'};
				$Fecha 			= $recibos[$i]->{'fecha'};
				$Valor			= $recibos[$i]->{'c_tot'};
				$Estado			= $recibos[$i]->{'estado'};
				$Valor_Efectivo	= $recibos[$i]->{'c_ef'};
				$Valor_Cheques	= $recibos[$i]->{'c_ch'};
				$Valor_Tarjeta	= $recibos[$i]->{'c_tar'};
				$Valor_Boletas	= $recibos[$i]->{'c_bol'};			
				$Numero_Notas	= 0;  //Por defecto se inserta 0						  
			
				$InstruccionBD = $conexion->prepare("insert into co_t_recibos (Tipo_Recibo, Serie_Recibo, Numero_Recibo, Fk_Cobrador, Fk_Cliente, Fecha, Valor, Estado, Valor_Efectivo, Valor_Cheques, Valor_Tarjeta, Valor_Boletas, Fecha_Recibido, Numero_Notas) values (?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?);");		 
				$InstruccionBD->bind_param('ssiissdsddddi', $Tipo_Recibo, $Serie_Recibo, $Numero_Recibo, $Fk_Cobrador, $Fk_Cliente, $Fecha, $Valor, $Estado, $Valor_Efectivo, $Valor_Cheques, $Valor_Tarjeta, $Valor_Boletas,  $Numero_Notas);				
				$InstruccionBD->execute();
				if ($InstruccionBD->errno) {
					  throw new Exception( "Ocurrio un error al intentar insertar el recibo No. " . $Numero_Recibo . " . Causa: " . $InstruccionBD->error);
				}
				$InstruccionBD ->close();		

				//****RECUPERAR EL PK DEL RECIBO GENERADO****
				$InstruccionBD = $conexion->prepare("select pk from co_t_recibos where tipo_recibo = ? and serie_recibo = ? and numero_recibo = ? and fk_cobrador = ? limit 1");		 
				$InstruccionBD->bind_param('ssii', $Tipo_Recibo, $Serie_Recibo, $Numero_Recibo, $Fk_Cobrador);				
				$InstruccionBD->execute();
				if ($InstruccionBD->errno) {
				  throw new Exception( "Ocurrio un error al intentar obtener la llave primaria  del recibo generado. Causa: " . $InstruccionBD->error);
				}
				$InstruccionBD->store_result();			
				$NumeroRegistros = $InstruccionBD->num_rows;
				if ( $NumeroRegistros > 0 ) {	
					$InstruccionBD->data_seek(0);
					$InstruccionBD->bind_result($recibo_pk);
					$InstruccionBD->fetch();							
				}
				else
				{
					throw new Exception( "Ocurrio un error al intentar recuperar la llave primaria del recibo No. " . $Numero_Recibo) ;
				}
				$InstruccionBD ->close();

				//****INSERTAR RECIBOS DOCUMENTOS ****
				$docs =  $recibos[$i]->{'docs'};
				for ($j=0; $j<count($docs); $j++){
					$Fk_Recibo		=	$recibo_pk;
					$Fk_Documento	=	$docs[$j]->{'id'};
					$Monto			=	$docs[$j]->{'val_cobrado'};
					$Saldo_Tel		=	$docs[$j]->{'saldo'};
												
					//Obtener saldo_sys
					$InstruccionBD = $conexion->prepare("select saldo from co_t_documentos where pk = ? limit 1");
					$InstruccionBD->bind_param('i', $Fk_Documento);
					$InstruccionBD->execute();
					if ($InstruccionBD->errno) {
					  throw new Exception( "Ocurrio un error al intentar obtener la llave primaria del documento del recibo. Causa: " . $InstruccionBD->error);
					}
					$InstruccionBD->store_result();			
					$NumeroRegistros = $InstruccionBD->num_rows;
					if ( $NumeroRegistros > 0 ) {	
						$InstruccionBD->data_seek(0);
						$InstruccionBD->bind_result($Saldo_Sys);
						$InstruccionBD->fetch();	
													
					}
					else
					{
						$Saldo_Sys=$Monto;
					}
					//Le descontamos al saldo del sistema el monto recibido en el documento
					$Saldo_Sys-=$Monto;
					
					//Insertar a el documento del recibo a la base de datos							
					$InstruccionBD = $conexion->prepare("insert into co_t_recibos_documentos (Fk_Recibo, Fk_Documento, Monto, Saldo_Tel, Saldo_Sys) values (?,?,?,?,?);");		 
					$InstruccionBD->bind_param('iiddd', $Fk_Recibo, $Fk_Documento, $Monto, $Saldo_Tel, $Saldo_Sys);				
					$InstruccionBD->execute();	
					if ($InstruccionBD->errno) {
					  throw new Exception( "Ocurrio un error al insertar el documento del recibo. Causa: " . $InstruccionBD->error);
					}
					$InstruccionBD ->close();
					

					//Actualizar el nuevo saldo_sys
					$InstruccionBD = $conexion->prepare("update co_t_documentos set saldo = ? where pk = ?");
					$InstruccionBD->bind_param('di',$Saldo_Sys, $Fk_Documento );				
					$InstruccionBD->execute();
					if ($InstruccionBD->errno) {
					  throw new Exception( "Ocurrio un error al actualizar el saldo del documento. Causa: " . $InstruccionBD->error);
					}	
					$InstruccionBD ->close();
					
				}
				$CantDocsLiq+=count($docs);//Sumar los documentos del recibo insertados a los docs de la liquidacion
				//****FIN:  INSERTAR RECIBOS DOCUMENTOS ****
				
				//INSERTAR FORMAS DE PAGO
				//Se insertaran formas de pago unicamente para los recibos de caja
				if ($Tipo_Recibo == "D")
				{
					$formas_de_pago=$recibos[$i]->{'formas_de_pago'};
		        	for ($j=0; $j<count($formas_de_pago); $j++)
		        	{
		        		$Tipo_Forma_Pago= $formas_de_pago[$j]->{'tipo'};
			        	if ($Tipo_Forma_Pago == "BOLETA" )	
			        	{
				        	//Insertar una a una las forma de pago	
				        	$Fk_Recibo 		= $recibo_pk;
				        	$Tipo_Forma_Pago= $formas_de_pago[$j]->{'tipo'};
				        	$Numero 		= $formas_de_pago[$j]->{'no_forma_pago'};
				        	$Fecha 			= $formas_de_pago[$j]->{'fecha'};
				        	$Codigo_Emisor 	= $formas_de_pago[$j]->{'emisor_cod'};
				        	$Monto 			= $formas_de_pago[$j]->{'monto'};
				        	$Referencia 	= $formas_de_pago[$j]->{'ref'};
							$InstruccionBD = $conexion->prepare("insert into co_t_recibos_forma_pago (Fk_Recibo, Tipo_Forma_Pago, Numero, Fecha, Codigo_Emisor, Monto, Referencia, Fecha_Envio) values (?,?,?,?,?,?,?,NOW());");		 
							$InstruccionBD->bind_param('isssids', $Fk_Recibo, $Tipo_Forma_Pago, $Numero, $Fecha, $Codigo_Emisor, $Monto, $Referencia);				
							$InstruccionBD->execute();	
							if ($InstruccionBD->errno) {
							  throw new Exception( "Ocurrio un error al intentar insertar la forma de pago. Causa:" . $InstruccionBD->error);
							}
							$InstruccionBD ->close();

							//Obtener el pk de la forma de pago
							$InstruccionBD = $conexion->prepare("select pk from co_t_recibos_forma_pago where fk_recibo = ? and tipo_forma_pago = ? and numero = ? and monto = ? limit 1");		 
							$InstruccionBD->bind_param('issd', $recibo_pk, $Tipo_Forma_Pago, $Numero, $Monto);				
							$InstruccionBD->execute();
							if ($InstruccionBD->errno) {
							  throw new Exception( "Ocurrio un error al intentar obtener la llave primaria de la forma de pago. Causa:" . $InstruccionBD->error);
							}
							$InstruccionBD->store_result();			
							$NumeroRegistros = $InstruccionBD->num_rows;
							if ( $NumeroRegistros > 0 ) {	
								$InstruccionBD->data_seek(0);
								$InstruccionBD->bind_result($tipo_forma_pago_pk);
								$InstruccionBD->fetch();							
							}
							else
							{
								throw new Exception( "Ocurrio un error al intentar recuperar la llave primaria de la forma de pago No. " . $Numero) ;
							}
							$InstruccionBD ->close();

							//Insertar liquidaciones boletas
							$InstruccionBD = $conexion->prepare(" insert into co_t_liquidaciones_boletas (fk_liquidacion, fk_forma_pago) values (?,?);");		 
							$InstruccionBD->bind_param('ii', $liquidacion_pk, $tipo_forma_pago_pk);				
							$InstruccionBD->execute();	
							if ($InstruccionBD->errno) {
							  throw new Exception( "Ocurrio un error al intentar insertar la forma de pago en la liquidacion. Causa: " . $InstruccionBD->error);
							}
							$InstruccionBD ->close();
							//Fin: Insertar liquidaciones boletas
			        	}	



			        }
			        $CantDocsLiq+=count($formas_de_pago);//Sumar las formas de pago insertados a los docs de la liquidacion
			        //Fin: insertar formas de pago
				}
				
		         
		        //INSERTAR CHEQUES PREFECHADOS
				$cheques_prefechados=$recibos[$i]->{'cheques_prefechados'};
		        for ($j=0; $j<count($cheques_prefechados); $j++){

		        	$fk_cliente 	= $cheques_prefechados[$j]->{'cliente'};
		        	$fk_cobrador 	= $cod_cobrador;
		        	$fk_recibo 		= $recibo_pk;
		        	$fk_banco 		= $cheques_prefechados[$j]->{'cod_emisor'};
		        	$numero 		= $cheques_prefechados[$j]->{'no_cheque'};
		        	$fecha 			= $cheques_prefechados[$j]->{'fecha'};
		        	$valor 			= $cheques_prefechados[$j]->{'monto'};
		        	$referencia 	= $cheques_prefechados[$j]->{'ref'};
		        	$estado 		= $cheques_prefechados[$j]->{'estado'};

		        	$InstruccionBD = $conexion->prepare("insert into co_t_cheques_prefechados (fk_cliente, fk_cobrador, fk_recibo, fk_banco, numero, fecha, valor, referencia, estado, fecha_envio) values (?,?,?,?,?,?,?,?,?,NOW());");		 
					$InstruccionBD->bind_param('siiiisdss', $fk_cliente, $fk_cobrador, $fk_recibo, $fk_banco, $numero, $fecha, $valor, $referencia, $estado);				
					$InstruccionBD->execute();	
					if ($InstruccionBD->errno) {
					  throw new Exception( "Ocurrio un error al intentar insertar el cheque prefechado. Causa: " . $InstruccionBD->error);
					}
					$InstruccionBD ->close();

					//Obtener el pk del cheque prefechado ingresado
					$InstruccionBD = $conexion->prepare("select pk from co_t_cheques_prefechados where  fk_cliente = ? and fk_cobrador = ? and fk_recibo = ? and fk_banco = ? and numero = ? and valor = ? limit 1");		 
					$InstruccionBD->bind_param('siiiid', $fk_cliente, $fk_cobrador, $recibo_pk, $fk_banco, $numero, $valor);				
					$InstruccionBD->execute();
					if ($InstruccionBD->errno) {
					  throw new Exception( "Ocurrio un error al intentar obtener la llave primaria del cheque prefechado. Causa:" . $InstruccionBD->error);
					}
					$InstruccionBD->store_result();			
					$NumeroRegistros = $InstruccionBD->num_rows;
					if ( $NumeroRegistros > 0 ) {	
						$InstruccionBD->data_seek(0);
						$InstruccionBD->bind_result($cheque_pre_pk);
						$InstruccionBD->fetch();							
					}
					else
					{
						throw new Exception( "Ocurrio un error al intentar recuperar la llave primaria del cheque prefechado No. " . $numero) ;
					}
					$InstruccionBD ->close();

					//Insertar cheque prefechado liquidacion
					$InstruccionBD = $conexion->prepare("insert into co_t_liquidaciones_chequespre (fk_liquidacion, fk_cheque_pre) values (?,?);");		 
					$InstruccionBD->bind_param('ii', $liquidacion_pk,$cheque_pre_pk);				
					$InstruccionBD->execute();	
					if ($InstruccionBD->errno) {
					  throw new Exception( "Ocurrio un error al intentar insertar el cheque prefechado en la liquidacion. Causa: " . $InstruccionBD->error);
					}
					$InstruccionBD ->close();
					//Fin: Insertar cheque prefechado liquidacion


		        }
		        $CantDocsLiq+=count($cheques_prefechados);//Sumar los cheques prefechados insertados a los docs de la liquidacion
		        //Fin: insertar cheques prefechados   


		        //INSERTAR LIQUIDACION RECIBO
				$InstruccionBD = $conexion->prepare("insert into co_t_liquidaciones_recibos (fk_liquidacion, fk_recibo) values (?, ?);");		 
				$InstruccionBD->bind_param('ii', $liquidacion_pk, $recibo_pk);				
				$InstruccionBD->execute();	
				if ($InstruccionBD->errno) {
				  throw new Exception( "Ocurrio un error al intentar insertar el recibo en la liquidacion. Causa: " . $InstruccionBD->error);
				}
				$InstruccionBD ->close();     
		        //Fin: Insertar Liquidacion Recibo
			 
		   }
		    $CantDocsLiq+=count($recibos);//Sumar los depositos insertados a los docs de la liquidacion
		   //****FIN:  INSERTAR RECIBOS A LA DB****

		    //Actualizamos la cantidad de documentos insertados a la db
		    $InstruccionBD = $conexion->prepare("update co_t_liquidaciones set numero_documentos = ? where Pk = ?");
			$InstruccionBD->bind_param('ii',$CantDocsLiq, $liquidacion_pk);			
			$succes=$InstruccionBD->execute();	
			if ($InstruccionBD->errno) {
			  throw new Exception( "Ocurrio un error al actualizar la cantidad de documentos de la liquidacion. Causa: " . $InstruccionBD->error);
			}
			$InstruccionBD ->close();

		}
		
		// Finalizamos la transaccion en true
		$conexion->commit();
		$ack="true";
	    $msg="Liquidacion almacenada satisfactoriamente.";
		$respuesta=json_decode('{"ack":' . $ack . ',"msg":"' . $msg . '","liquidacion_pk":' . $liquidacion_pk . ',"recibo_pk":' . $recibo_pk . "}");
		
	} catch (Exception $e) {	
		 // Finalizamos la transaccion en false
		$msg=$e->getMessage();
		$conexion->rollback();
	    $conexion->close();
	    $ack="false";
		$respuesta=json_decode('{"ack":"' . $ack . '","msg":"' . $msg . '"}');
	
	} 



	header('Content-Type: application/json');
	echo json_encode($respuesta);


?>